from si_tests import settings
from si_tests import logger
from si_tests.utils import waiters


LOG = logger.logger


def update_os_controller(os_manager):

    timeout = settings.OPENSTACK_LCM_OPERATIONS_TIMEOUT
    osdpl_name = settings.OSH_DEPLOYMENT_NAME
    os_operator_hb_name = settings.OSH_OPERATOR_HB_NAME

    # Check that all fingerprints in actual state before update
    LOG.info("Check all fingreprints are in actual state")
    os_manager.wait_openstack_helmbundles_fingerprint(osdpl_name)

    # Save images of helmbundles before update
    LOG.info("Getting all helm images")
    images_before_update = os_manager.get_os_helmbundle_images()

    # Save OpenStack deployment before update
    osdpl = os_manager.get_openstackdeployment(osdpl_name)
    osdpl_before_update = osdpl.read()

    # Save health section before update
    osdpl_status = os_manager.get_openstackdeployment_status(osdpl_name)
    osdpl_before_update_status = osdpl_status.read()
    health_before_update = osdpl_before_update_status.status['health']

    os_controller_helmbundle = os_manager.get_os_operator_helmbundle(
        os_operator_hb_name)

    # Prepare and apply updates for image of openstack controller hb
    update = os_controller_helmbundle.read()

    if update.spec['releases'][0]['values'].get('image', {}).get('fullName'):
        update.spec['releases'][0]['values']['image'].update(
            fullName="{repo}:{tag}".format(
                repo=settings.OSH_OPERATOR_UPDATE_REPO,
                tag=settings.OSH_OPERATOR_UPDATE_TAG)
        )
    else:
        update.spec['releases'][0]['values'].update({'image': {
            'fullName': "{repo}:{tag}".format(
                repo=settings.OSH_OPERATOR_UPDATE_REPO,
                tag=settings.OSH_OPERATOR_UPDATE_TAG)}})

    if settings.OSH_OPERATOR_CHART_URL:
        update.spec['releases'][0]['chartURL'] = settings.OSH_OPERATOR_CHART_URL

    os_controller_helmbundle.patch(update)

    # Prepare and apply osdpl artifacts update.
    # Set images_base_url and binary_base_url to dev-kaas-local for
    # updating from release to dev version of controller.
    artifacts_region_map = settings.ARTIFACTS_REGION_MAPPING
    cdn_region = settings.CDN_REGION
    binary_base_url = artifacts_region_map[cdn_region]["binary_base_url"]
    images_base_url = artifacts_region_map[cdn_region]["images_base_url"]

    osdpl_update = {
        'spec': {
            'artifacts': {
                'images_base_url': images_base_url,
                'binary_base_url': binary_base_url
            }
        }
    }
    osdpl.patch(osdpl_update)

    LOG.info("Waiting for version of osdpl updated")
    waiters.wait((lambda expected:
                  expected != os_manager.get_openstackdeployment(
                      osdpl_name).read().status['version']),
                 predicate_kwargs={
                     'expected': osdpl_before_update.status['version']},
                 timeout=timeout,
                 timeout_msg="Version of osdpl wasn't updated")

    LOG.info("Check all helmbundles fingerprints equals fp of osdpl")
    os_manager.wait_openstack_helmbundles_fingerprint(osdpl_name,
                                                      timeout=timeout)

    LOG.info("Wait all helmbundles version equals to new version")
    os_manager.wait_openstack_helmbundles_version_update(osdpl_name,
                                                         timeout=timeout)

    LOG.info("Wait until all osdpl children statuses success=True")
    os_manager.wait_all_osdpl_children_status(timeout=timeout)

    LOG.info("Wait osdpl status deployed is True")
    os_manager.wait_os_deployment_status(timeout=timeout, status='APPLIED')

    # Save images of helmbundles after update
    images_after_update = os_manager.get_os_helmbundle_images()

    # Check images for charts in OpenStack helmbundles was updated
    updated_helmbundles = []
    for hb_name, chart in images_before_update.items():
        for chart_name, images in chart.items():
            if images != images_after_update.get(hb_name).get(
                    chart_name):
                updated_helmbundles.append("{hb}:{chart}".format(
                    hb=hb_name,
                    chart=chart_name))

    if updated_helmbundles:
        LOG.info("Images were updated for openstack helmbundles: "
                 "{updated_helmbundles}".format(
                     updated_helmbundles=updated_helmbundles))

        LOG.info("Wait health section updated once")
        waiters.wait((lambda before:
                      before != os_manager.get_openstackdeployment_status(
                          settings.OSH_DEPLOYMENT_NAME).read().status.get(
                          'health')),
                     predicate_kwargs={'before': health_before_update},
                     timeout=timeout,
                     timeout_msg="Health of Openstack deployment was "
                                 "not changed during update.")

        LOG.info("Wait until all services in health section"
                 " get status `Ready`")
        os_manager.wait_openstackdeployment_health_status()

    LOG.info("Check that OpenStack pods are active.")
    os_manager.wait_os_resources(timeout=timeout, interval=20)
    LOG.info("OpenStack controller updated successfully.")
