#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1NodeMaintenanceRequest(base.BaseModel):
    pass


class V1NodeMaintenanceRequestList(base.BaseModelList):
    pass


class NodeMaintenanceRequest(base.K8sClusterScopedResource):
    resource_type = 'nodemaintenancerequest'
    model = V1NodeMaintenanceRequest

    @property
    def nodename(self):
        return self.data['spec']['nodeName']

    @property
    def state(self):
        return self.data['status']['state']


class NodeMaintenanceRequestManager(base.K8sBaseManager):
    model = V1NodeMaintenanceRequestList
    resource_class = NodeMaintenanceRequest
    resource_group = 'lcm.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'nodemaintenancerequests'

    def create_node_maintenance_request(self, node, name, scope="os"):
        body = {
            "apiVersion": "lcm.mirantis.com/v1alpha1",
            "kind": "NodeMaintenanceRequest",
            "metadata": {"name": name},
            "spec": {"nodeName": node, "scope": scope},
        }
        self.create(body=body)

    def delete_node_maintenance_request(self, name):
        nmr = self.get(name)
        nmr.delete(name)
