#!/bin/bash
echo "Collecting Ceph cluster data."

if [ "$#" -lt 2 ]; then echo "Usage: ./ceph_collect.sh <CUSTOMER> <CLUSTERNAME>"; exit; fi
export CUSTOMER=$1
export CLUSTERNAME=$2

if ! which ceph >/dev/null; then echo "ERROR: This script must be run on a ceph monitor or admin node"; exit; fi

DATE=`date "+%Y-%m-%d"`
DIRNAME="CephCollectData.$CUSTOMER.$CLUSTERNAME.$DATE"
ARCHNAME=$DIRNAME".tar.gz"
mkdir $DIRNAME
cd $DIRNAME

echo "Collecting CRUSH map"
ceph osd getcrushmap -o crush.bin
crushtool -d crush.bin -o crushmap.txt
crushtool -i crush.bin --dump > crushmap.json
rm crush.bin

echo "Collecting ceph osd crush dump"
ceph osd crush dump >crushdump.json 

echo "Collecting cluster status"
ceph -s -f json -o ceph_s.json
echo "Collecting health detail"
ceph -f json health detail -o ceph_healt_detail.json
echo "Collecting monmap"
ceph mon dump -f json -o monmap.json
echo "Collecting ceph df"
ceph df -f json -o ceph_df.json
echo "Collecting ceph osd df"
ceph osd df -f json -o ceph_osd_df.json
echo "Collecting ceph osd dump"
ceph osd dump -f json -o ceph_osd_dump.json
echo "Collecting rados df"
rados df -f json >rados_df.json
echo "Collecting ceph report"
ceph report -o ceph_report.json
echo "Collecting auth data anonymized"
ceph auth list -f json |sed 's/AQ[^=]*==/KEY/g' > ceph_auth_ls.json
echo "Collecting ceph pg dump"
ceph pg dump -f json -o ceph_pg_dump.json
echo "Collecting health metrics"
mkdir ceph-health
IFS=$'\n'; for device in `ceph device ls|grep -v DEVICE`; do osd=$(echo $device|awk '{print $3}'); dev=$(echo $device|awk '{print $1}'); ceph device get-health-metrics $dev >ceph-health/$osd-$dev.json ; done
echo "Collecting ceph osd perf"
for i in {0..9}; do echo $i; ceph osd perf -f json -o ceph_osd_perf_$i.json; sleep 4; done
echo "Collecting ceph running configuration"
ceph config dump -f json >ceph_config_dump.json

tar czf "../"$ARCHNAME *

