package images

import (
	"github.com/rackspace/gophercloud"
	identity "github.com/rackspace/gophercloud/openstack/identity/v2"
)

type Client struct {
	endpoint  string
	authority identity.AuthResults
	options   gophercloud.AuthOptions
}

func NewClient(e string, a identity.AuthResults, ao gophercloud.AuthOptions) *Client {
	return &Client{
		endpoint:  e,
		authority: a,
		options:   ao,
	}
}

func (c *Client) getListUrl() string {
	return c.endpoint + "/images/detail"
}

func (c *Client) getListHeaders() (map[string]string, error) {
	t, err := identity.GetToken(c.authority)
	if err != nil {
		return map[string]string{}, err
	}

	return map[string]string{
		"X-Auth-Token": t.ID,
	}, nil
}
