package flavors

import (
  "testing"

  "github.com/rackspace/gophercloud"
  "github.com/rackspace/gophercloud/pagination"
  th "github.com/rackspace/gophercloud/testhelper"
  fake "github.com/rackspace/gophercloud/testhelper/client"
)

func TestList(t *testing.T) {
  th.SetupHTTP()
  defer th.TeardownHTTP()

  HandleListCDNFlavorsSuccessfully(t)

  count := 0

  err := List(fake.ServiceClient()).EachPage(func(page pagination.Page) (bool, error) {
    count++
    actual, err := ExtractFlavors(page)
    if err != nil {
      t.Errorf("Failed to extract flavors: %v", err)
      return false, err
    }

    expected := []Flavor{
      Flavor{
        ID:   "europe",
        Providers: []Provider{
          Provider{
            Provider: "Fastly",
            Links: []gophercloud.Link{
              gophercloud.Link{
                Href: "http: //www.fastly.com",
                Rel: "provider_url",
              },
            },
          },
        },
        Links: []gophercloud.Link{
          gophercloud.Link{
            Href: "https://www.poppycdn.io/v1.0/flavors/europe",
            Rel:  "self",
          },
        },
      },
    }

    th.CheckDeepEquals(t, expected, actual)

    return true, nil
  })
  th.AssertNoErr(t, err)

  if count != 1 {
    t.Errorf("Expected 1 page, got %d", count)
  }
}

func TestGet(t *testing.T) {
  th.SetupHTTP()
  defer th.TeardownHTTP()

  HandleGetCDNFlavorSuccessfully(t)

  expected := &Flavor{
    ID:   "asia",
    Providers: []Provider{
      Provider{
        Provider: "ChinaCache",
        Links: []gophercloud.Link{
          gophercloud.Link{
            Href: "http://www.chinacache.com",
            Rel:  "provider_url",
          },
        },
      },
    },
    Links: []gophercloud.Link{
      gophercloud.Link{
        Href: "https://www.poppycdn.io/v1.0/flavors/asia",
        Rel:  "self",
      },
    },
  }


  actual, err := Get(fake.ServiceClient(), "asia").Extract()
  th.AssertNoErr(t, err)
  th.AssertDeepEquals(t, expected, actual)
}
